PSCAD 4.2.0

Settings
 {
 Id = "1026928233.1144433184"
 Author = "Shaahin.jayas"
 Desc = "SIMPLEX - Minimize harmonics generated"
 Arch = "windows"
 Options = 0
 Build = 20
 Warn = 7
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.4
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0
  }

 }

Definitions
 {
 Component("Thee_Level")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Main")
    {
    Choice("N",2,0,288,12,2)
     {
     Style = 0
     Desc = "Number of Chops per Quarter-Cycle"
     Def = "1"
     Len = 15
     *1 = "1"
     *2 = "2"
     *3 = "3"
     *4 = "4"
     *5 = "5"
     *6 = "6"
     *7 = "7"
     *8 = "8"
     *9 = "9"
     *10 = "10"
     }
    Choice("L_0A1",162,18,130,12,2)
     {
     Style = 0
     Desc = "Level 0-Alpha1"
     Def = "1"
     Len = 15
     Cond = "N >= 1"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG1",2,32,120,12,6)
     {
     Desc = "First Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 1"
     }
    Choice("L_A1A2",162,44,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha1-Alpha2"
     Def = "1"
     Len = 15
     Cond = "N >= 2"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG2",2,56,120,12,6)
     {
     Desc = "Second Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 2"
     }
    Choice("L_A2A3",162,68,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha2-Alpha3"
     Def = "1"
     Len = 15
     Cond = "N >= 3"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG3",2,80,120,12,6)
     {
     Desc = "Third Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 3"
     }
    Choice("L_A3A4",162,92,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha3-Alpha4"
     Def = "1"
     Len = 15
     Cond = "N >= 4"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG4",2,104,120,12,6)
     {
     Desc = "Forth Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 4"
     }
    Choice("L_A4A5",162,116,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha4-Alpha5"
     Def = "1"
     Len = 15
     Cond = "N >= 5"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG5",2,128,120,12,6)
     {
     Desc = "Fifth Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 5"
     }
    Choice("L_A5A6",162,140,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha5-Alpha6"
     Def = "1"
     Len = 15
     Cond = "N >= 6"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG6",2,152,120,12,6)
     {
     Desc = "Sixth Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 6"
     }
    Choice("L_A6A7",162,164,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha6-Alpha7"
     Def = "1"
     Len = 15
     Cond = "N >= 7"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG7",2,176,120,12,6)
     {
     Desc = "Seventh Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 7"
     }
    Choice("L_A7A8",162,188,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha7-Alpha8"
     Def = "1"
     Len = 15
     Cond = "N >= 8"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG8",2,200,120,12,6)
     {
     Desc = "Eighth Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 8"
     }
    Choice("L_A8A9",162,212,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha8-Alpha9"
     Def = "1"
     Len = 15
     Cond = "N >= 9"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG9",2,224,120,12,6)
     {
     Desc = "Ninth Choping Angle"
     Data = Real
     Len = 5
     Cond = "N >= 9"
     }
    Choice("L_A9A10",162,236,130,12,2)
     {
     Style = 0
     Desc = "Level Alpha9-Alpha10"
     Def = "1"
     Len = 15
     Cond = "N >= 9"
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    Input("ANG10",2,248,120,12,6)
     {
     Desc = "Tenth Choping Angle"
     Data = Real
     Len = 5
     Cond = "N ==10"
     }
    Choice("L_A10PI2",162,260,130,12,2)
     {
     Style = 0
     Desc = "Last Level to PI/2"
     Def = "1"
     Len = 15
     *1 = "E"
     *0 = "0"
     *-1 = "-E"
     }
    }
   }

  Nodes = 
   {
   Input("Theta",-54,0)
    {
    Type = Real
    }
   Output("G2",36,18)
    {
    Type = Integer
    Dim  = [2]
    }
   Output("G1",36,-18)
    {
    Type = Integer
    Dim  = [2]
    }
   }

  Graphics = 
   {
   Pen(ByNode,ByNode,ByNode,Theta)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Pen(,ByNode,,G1)
   Line(36,-18,11,-18)
   Pen(,,,G2)
   Line(36,18,11,18)
   Pen(Black,Solid,0.2)
   Rectangle(-29,-28,12,28)
   Line(19,21,25,15)
   Line(19,-15,25,-21)
   Line(-4,-25,4,-25)
   Line(-4,10,4,10)
   Text(-7,22,"G2 G2")
   Text(-7,-13,"G1 G1")
   }

  Section(EMTDC)
   {
   Fortran = "\
#LOCAL INTEGER IVD1_1	! Counter
#LOCAL INTEGER IVD1_2       ! E_LEVEL
#LOCAL INTEGER IVD1_3       ! SIGN
#LOCAL INTEGER IVD12_1 12	! Vector of levels
#LOCAL REAL RVD12_1 12	! Vector of angles
#LOCAL REAL RVD1_1         ! PHI
#LOCAL REAL RVD1_2          ! MOD(THETA,360)
#LOCAL LOGICAL LVD1_1
      RVD12_1(1)    = 0.0
      RVD12_1(2)    = $ANG1
      RVD12_1(3)    = $ANG2
      RVD12_1(4)    = $ANG3
      RVD12_1(5)    = $ANG4
      RVD12_1(6)    = $ANG5
      RVD12_1(7)    = $ANG6
      RVD12_1(8)    = $ANG7
      RVD12_1(9)    = $ANG8
      RVD12_1(10)   = $ANG9
      RVD12_1(11)   = $ANG10
      RVD12_1($N+2) = 90.0
!
      IVD12_1(1)  = $L_0A1
      IVD12_1(2)  = $L_A1A2
      IVD12_1(3)  = $L_A2A3
      IVD12_1(4)  = $L_A3A4
      IVD12_1(5)  = $L_A4A5
      IVD12_1(6)  = $L_A5A6
      IVD12_1(7)  = $L_A6A7
      IVD12_1(8)  = $L_A7A8
      IVD12_1(9)  = $L_A8A9
      IVD12_1(10) = $L_A9A10
      IVD12_1(11) = $L_A10PI2
      IVD12_1($N+1) = $L_A10PI2
!
      RVD1_2 = MOD( $THETA, 360.0)
      IF ( RVD1_2 .LE. 90.0) THEN
        IVD1_3 = 1
        RVD1_1 = RVD1_2
      ELSEIF ( RVD1_2 .LE. 180.0) THEN
        IVD1_3 = 1
        RVD1_1 = 180.0 - RVD1_2
      ELSEIF ( RVD1_2 .LE. 270.0) THEN
        IVD1_3 = -1
        RVD1_1 = RVD1_2 - 180.0
      ELSE 
        IVD1_3 = -1
        RVD1_1 = 360.0 - RVD1_2
      ENDIF
      LVD1_1 = .FALSE.
      IVD1_1 = 2
      DO WHILE (.NOT. LVD1_1)
         LVD1_1 = (RVD1_1 .GE. RVD12_1(IVD1_1-1)) .AND. (RVD1_1 .LE. RVD12_1(IVD1_1))
         IF (LVD1_1) THEN
            IVD1_2 = IVD1_3 * IVD12_1( IVD1_1-1)
         ELSE
            IVD1_1 = IVD1_1 + 1
            IF (IVD1_1 .GT. $N+2) LVD1_1=.TRUE.
         ENDIF
      ENDDO
!		
      IF ( IVD1_2 .NE. -1) THEN
        $G1(1) = 1
      ELSE
        $G1(1) = 0
      ENDIF
      IF ( IVD1_2 .NE. 1) THEN
        $G2(1) = 0
      ELSE
        $G2(1) = 1
      ENDIF			
      $G1(2) = 1 - $G1(1)
      $G2(2) = 1 - $G2(1)"
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,16,[597,467],100)
   {
   -Wire-([216,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([234,954],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([216,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([234,1098],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([216,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([234,1170],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([216,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([216,1170],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([234,882],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([216,828],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([216,1188],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.voltmetergnd([594,1008],0,0,60)
    {
    Name = "Vabc"
    }
   0.datalabel([1062,1458],0,0,-1)
    {
    Name = "Vabc"
    }
   -Wire-([1062,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([990,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datatap([450,306],6,0,540)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([522,378],0,0,510)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([450,378],0,0,520)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([450,306],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([450,378],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([306,342],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([216,846],2,0,730)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([216,1134],2,0,640)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([144,900],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([144,1116],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([216,1098],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([216,882],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([216,1062],2,0,670)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([216,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([144,1116],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([144,936],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([144,1080],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([216,954],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.datalabel([180,882],0,0,-1)
    {
    Name = "G2a"
    }
   0.datalabel([180,954],0,0,-1)
    {
    Name = "G1a"
    }
   0.datalabel([180,1098],0,0,-1)
    {
    Name = "G2bar_a"
    }
   0.datalabel([180,1170],0,0,-1)
    {
    Name = "G1bar_a"
    }
   0.datalabel([450,378],3,0,-1)
    {
    Name = "G2a"
    }
   0.datalabel([522,306],2,0,-1)
    {
    Name = "G1bar_a"
    }
   0.datatap([522,306],6,0,530)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([522,378],0,0,-1)
    {
    Name = "G2bar_a"
    }
   -Wire-([342,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([360,954],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([342,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([360,1098],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([342,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([360,1170],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([342,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,1170],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([360,882],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([342,828],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.peswitch([342,846],2,0,720)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([342,1134],2,0,630)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([270,900],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([270,1116],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([342,1098],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([342,882],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([342,918],2,0,690)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([342,1062],2,0,660)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([342,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([270,1116],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([270,1080],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([342,954],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.peswitch([270,936],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([468,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([468,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([486,954],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([468,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([468,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([486,1098],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([468,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([486,1170],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([468,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([468,1170],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([486,882],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([468,828],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([468,1188],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.peswitch([468,846],2,0,710)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([468,1134],2,0,620)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([396,900],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([396,1116],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([468,1098],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([468,882],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([468,918],2,0,680)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([468,1062],2,0,650)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([468,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.peswitch([396,1116],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([396,1080],0,0,-1)
    {
    Vertex="0,0;0,-144"
    }
   -Wire-([468,954],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.peswitch([396,936],0,0,-1)
    {
    L = "D"
    Type = "0"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([342,1188],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.inductor([630,1080],7,0,-1)
    {
    L = "0.2 [H]"
    }
   -Wire-([540,1008],0,0,-1)
    {
    Vertex="0,0;-198,0"
    }
   -Wire-([216,972],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   -Wire-([468,1044],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([306,882],0,0,-1)
    {
    Name = "G2b"
    }
   0.datalabel([306,954],0,0,-1)
    {
    Name = "G1b"
    }
   0.datalabel([306,1098],0,0,-1)
    {
    Name = "G2bar_b"
    }
   0.datalabel([306,1170],0,0,-1)
    {
    Name = "G1bar_b"
    }
   0.datalabel([432,954],0,0,-1)
    {
    Name = "G1c"
    }
   0.datalabel([432,1098],0,0,-1)
    {
    Name = "G2bar_c"
    }
   0.datalabel([432,1170],0,0,-1)
    {
    Name = "G1bar_c"
    }
   0.ammeter([630,1008],1,0,70)
    {
    Name = "Iabc"
    }
   0.datalabel([990,1458],0,0,-1)
    {
    Name = "Iabc"
    }
   0.pgb([1080,1458],0,25390448,210)
    {
    Name = "Vabc"
    Group = "Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datatap([450,486],6,0,500)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,558],0,0,470)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([450,558],0,0,480)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([450,666],6,0,460)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,738],0,0,430)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([450,738],0,0,440)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([504,666],6,0,450)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.sumjct([288,702],0,0,230)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([252,522],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([234,540],0,0,-1)
    {
    Vertex="0,0;0,-198"
    }
   -Wire-([234,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([234,540],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([234,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datatap([504,486],6,0,490)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([414,324],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([414,360],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datalabel([450,306],3,0,-1)
    {
    Name = "G1a"
    }
   -Wire-([414,540],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([414,504],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([414,720],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([414,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([450,486],3,0,-1)
    {
    Name = "G1b"
    }
   0.datalabel([504,486],2,0,-1)
    {
    Name = "G1bar_b"
    }
   0.datalabel([450,558],3,0,-1)
    {
    Name = "G2b"
    }
   0.datalabel([504,558],0,0,-1)
    {
    Name = "G2bar_b"
    }
   0.datalabel([450,666],3,0,-1)
    {
    Name = "G1c"
    }
   0.datalabel([504,666],2,0,-1)
    {
    Name = "G1bar_c"
    }
   0.datalabel([450,738],3,0,-1)
    {
    Name = "G2_c"
    }
   0.datalabel([432,882],0,0,-1)
    {
    Name = "G2_c"
    }
   0.pgb([450,288],3,25415408,790)
    {
    Name = "G1_a"
    Group = "Gate Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,396],7,25418104,780)
    {
    Name = "G2_a"
    Group = "Gate Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,468],3,25420880,770)
    {
    Name = "G1_b"
    Group = "Gate Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,576],7,25423824,760)
    {
    Name = "G2_b"
    Group = "Gate Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,648],3,25426600,750)
    {
    Name = "G1_c"
    Group = "Gate Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([450,756],7,25429352,740)
    {
    Name = "G2_c"
    Group = "Gate Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.sumjct([288,522],0,0,220)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([702,1206],0,0,-1)
    {
    Name = "Isource"
    }
   0.vco([144,522],0,0,20)
    {
    Mode = "1"
    }
   -Wire-([90,828],0,0,-1)
    {
    Vertex="0,0;378,0"
    }
   -Wire-([90,1188],0,0,-1)
    {
    Vertex="0,0;378,0"
    }
   -Wire-([702,1206],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.pgb([792,1170],0,25436112,90)
    {
    Name = "Filtered Source Current"
    Group = "Current"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([720,1206],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.const([288,594],3,0,30)
    {
    Name = ""
    Value = "240.0"
    }
   0.const([288,774],3,0,40)
    {
    Name = ""
    Value = "120.0"
    }
   0.datalabel([504,738],0,0,-1)
    {
    Name = "G2bar_c"
    }
   0.ground([90,1026],2,0,-1)
    {
    }
   -Wire-([90,918],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([90,1188],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([90,846],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.peswitch([216,918],2,0,700)
    {
    L = "T"
    Type = "3"
    SNUB = "0"
    INTR = "0"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.datalabel([684,1332],2,0,-1)
    {
    Name = "Vabc"
    }
   0.datalabel([918,1332],6,0,-1)
    {
    Name = "Iabc"
    }
   -Wire-([846,1314],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1080,1314],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1098,1314],2,0,-1)
    {
    Name = "ih"
    }
   0.pgb([864,1314],0,25449040,600)
    {
    Name = "Voltage Harmonics"
    Group = "Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "12.0"
    }
   0.datatap([180,1368],6,0,250)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1404],6,0,280)
    {
    Index = "5"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1440],6,0,180)
    {
    Index = "7"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.sumjct([180,1296],0,0,300)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([180,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([180,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([288,1332],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([324,1332],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([324,1404],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([126,1332],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([90,1296],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.square([252,1296],0,0,310)
    {
    Dim = "1"
    }
   0.datalabel([504,1296],0,0,-1)
    {
    Name = "Obj"
    }
   0.pgb([504,1296],0,25460800,610)
    {
    Name = "Objective Function"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "2.0"
    }
   0.mult([396,1296],0,0,330)
    {
    }
   0.integral([468,1296],0,0,340)
    {
    Extrn = "0"
    Reset = "0"
    Mthd = "0"
    noname5 = ""
    INTR = "0"
    INTCLR = "0"
    T = "1 [s]"
    Yo = "0.0"
    YRst = "0.0"
    YHi = "10000.0"
    YLo = "-10000.0"
    }
   -Wire-([396,1368],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.time-sig([504,1368],4,0,130)
    {
    }
   0.square([252,1404],0,0,290)
    {
    Dim = "1"
    }
   0.pgb([1008,1458],0,25467416,200)
    {
    Name = "Iabc"
    Group = "Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([882,1188],0,0,-1)
    {
    Name = "Obj"
    }
   0.pgb([792,1206],0,25471144,100)
    {
    Name = "Source Current"
    Group = "Current"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([1026,1206],0,0,-1)
    {
    Name = "a1"
    }
   0.datalabel([1062,1206],0,0,-1)
    {
    Name = "a2"
    }
   0.datatap([1026,1206],0,0,390)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1062,1206],0,0,380)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1098,1206],0,0,-1)
    {
    Name = "a3"
    }
   0.datalabel([702,1458],0,0,-1)
    {
    Name = "a1"
    }
   0.datalabel([774,1458],0,0,-1)
    {
    Name = "a2"
    }
   0.datalabel([846,1458],0,0,-1)
    {
    Name = "a3"
    }
   0.pgb([720,1458],0,25480624,580)
    {
    Name = "Alpha1"
    Group = "Alpha"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "20"
    }
   0.pgb([792,1458],0,25483304,570)
    {
    Name = "Alpha2"
    Group = "Alpha"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "30"
    Max = "50"
    }
   0.pgb([864,1458],0,25486080,560)
    {
    Name = "Alpha3"
    Group = "Alpha"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "50"
    Max = "70"
    }
   0.pgb([1098,1314],0,25488856,590)
    {
    Name = "Current Harmonics"
    Group = "Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "0.2"
    }
   0.realpole([756,1170],0,0,80)
    {
    Limit = "0"
    COM = "Real_Pole"
    Reset = "0"
    YO = "0.0"
    G = "1.0"
    T = "0.01 [s]"
    Max = "10.0"
    Min = "-10.0"
    }
   0.source1([90,882],1,0,50)
    {
    Name = "Source1"
    Type = "1"
    Ctrl = "0"
    Vm = "110.00 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "20.0 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.01 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "Isource"
    }
   0.source1([90,1116],1,0,-1)
    {
    Name = "Source1"
    Type = "1"
    Ctrl = "0"
    Vm = "110.00 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "20.0 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.01 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = ""
    }
   0.fft([774,1350],0,0,150)
    {
    Type = "1"
    Size = "2"
    F = "$(freq) [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "2"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.fft([1008,1350],0,0,170)
    {
    Type = "1"
    Size = "2"
    F = "$(freq) [Hz]"
    AMod = "0"
    PMod = "0"
    PModCS = "2"
    Filt = "1"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datalabel([108,1296],0,0,-1)
    {
    Name = "V1_ref"
    }
   0.datalabel([162,1350],0,0,-1)
    {
    Name = "vh"
    }
   0.sumjct([324,1296],0,0,320)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "1"
    F = "1"
    G = "1"
    }
   0.square([252,1368],0,0,260)
    {
    Dim = "1"
    }
   -Wire-([180,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.square([252,1440],0,0,190)
    {
    Dim = "1"
    }
   -Wire-([288,1440],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([360,1440],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.datatap([1098,1206],0,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1008,1188],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datatap([1134,1206],0,0,360)
    {
    Index = "4"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1134,1206],0,0,-1)
    {
    Name = "a4"
    }
   .Thee_Level([378,522],0,0,410)
    {
    N = "4"
    L_0A1 = "1"
    ANG1 = "a1"
    L_A1A2 = "0"
    ANG2 = "a2"
    L_A2A3 = "1"
    ANG3 = "a3"
    L_A3A4 = "0"
    ANG4 = "a4"
    L_A4A5 = "0"
    ANG5 = "50 [units]"
    L_A5A6 = "1"
    ANG6 = "0.0 [units]"
    L_A6A7 = "1"
    ANG7 = "0.0 [units]"
    L_A7A8 = "1"
    ANG8 = "0.0 [units]"
    L_A8A9 = "1"
    ANG9 = "0.0 [units]"
    L_A9A10 = "1"
    ANG10 = "0.0 [units]"
    L_A10PI2 = "1"
    }
   .Thee_Level([378,702],0,0,400)
    {
    N = "4"
    L_0A1 = "1"
    ANG1 = "a1"
    L_A1A2 = "0"
    ANG2 = "a2"
    L_A2A3 = "1"
    ANG3 = "a3"
    L_A3A4 = "0"
    ANG4 = "a4"
    L_A4A5 = "0"
    ANG5 = "50 [units]"
    L_A5A6 = "1"
    ANG6 = "0.0 [units]"
    L_A6A7 = "1"
    ANG7 = "0.0 [units]"
    L_A7A8 = "1"
    ANG8 = "0.0 [units]"
    L_A8A9 = "1"
    ANG9 = "0.0 [units]"
    L_A9A10 = "1"
    ANG10 = "0.0 [units]"
    L_A10PI2 = "1"
    }
   0.datalabel([918,1458],0,0,-1)
    {
    Name = "a4"
    }
   0.pgb([936,1458],0,25514240,550)
    {
    Name = "Alpha4"
    Group = "Alpha"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "60"
    Max = "80"
    }
   0.var([54,1296],0,25517104,110)
    {
    Name = "Vref"
    Group = "Voltage"
    Display = "0"
    Max = "15.0"
    Min = "0.0"
    Value = "11.0"
    Units = "kV"
    Collect = "1"
    }
   0.pgb([126,1332],0,25520152,120)
    {
    Name = "Ref. Vol."
    Group = "Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.ground([630,1116],1,0,-1)
    {
    }
   0.resistor([630,1044],1,0,-1)
    {
    R = "80.0 [ohm]"
    }
   0.compare([432,1368],4,0,270)
    {
    X = "0.05"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   -SrcFile-([1044,1116],0)
    {
   Name = "simplex_minharm.emt\\optimumrun.out"
    }
   .Thee_Level([378,342],0,0,420)
    {
    N = "4"
    L_0A1 = "1"
    ANG1 = "a1"
    L_A1A2 = "0"
    ANG2 = "a2"
    L_A2A3 = "1"
    ANG3 = "a3"
    L_A3A4 = "0"
    ANG4 = "a4"
    L_A4A5 = "0"
    ANG5 = "50 [units]"
    L_A5A6 = "1"
    ANG6 = "0.0 [units]"
    L_A6A7 = "1"
    ANG7 = "0.0 [units]"
    L_A7A8 = "1"
    ANG8 = "0.0 [units]"
    L_A8A9 = "1"
    ANG9 = "0.0 [units]"
    L_A9A10 = "1"
    ANG10 = "0.0 [units]"
    L_A10PI2 = "1"
    }
   0.optimum_run([954,1188],0,0,350)
    {
    OM = "2"
    NVR = "4"
    NVI = "1"
    NVB = "1"
    MRUNS = "501"
    TOL = "2e-3"
    Enab = "1"
    SM = "0"
    LHP = ""
    RHP = ""
    SP = ""
    ISL = ""
    SEF = ""
    SIB = ""
    ISP = "-5.0"
    SRF = ""
    IC1 = "15"
    IC2 = "40"
    IC3 = "60"
    IC4 = "75"
    IC5 = ""
    IC6 = ""
    IC7 = ""
    IC8 = ""
    IC9 = ""
    IC10 = ""
    IC11 = ""
    IC12 = ""
    IC13 = ""
    IC14 = ""
    IC15 = ""
    IC16 = ""
    IC17 = ""
    IC18 = ""
    IC19 = ""
    IC20 = ""
    IP = ""
    PSG = ""
    PMP = ""
    BMR = ""
    RMR = ""
    PM = "1"
    LL1 = ""
    UL1 = ""
    LL2 = ""
    UL2 = ""
    LL3 = ""
    UL3 = ""
    LL4 = ""
    UL4 = ""
    LL5 = ""
    UL5 = ""
    LL6 = ""
    UL6 = ""
    LL7 = ""
    UL7 = ""
    LL8 = ""
    UL8 = ""
    LL9 = ""
    UL9 = ""
    LL10 = ""
    UL10 = ""
    BL1 = "1"
    BL2 = "1"
    BL3 = "1"
    BL4 = "1"
    BL5 = "1"
    BL6 = "1"
    BL7 = "1"
    BL8 = "1"
    BL9 = "1"
    BL10 = "1"
    Meas = "1"
    Fname = "optimumrun.out"
    }
   -Sticky-([72,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 72,18,1152,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "OPTIMIZING A 4 VARIABLE FUNCTION USING SIMPLEX OPTIMZER"
    }
   -Wire-([162,1386],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([162,1476],0,0,-1)
    {
    Name = "vh"
    }
   0.datalabel([864,1314],2,0,-1)
    {
    Name = "vh"
    }
   0.breakout([576,1008],4,0,-1)
    {
    Dis = "0"
    }
   -Wire-([576,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([702,1350],0,0,140)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([936,1350],0,0,160)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([180,1332],6,0,240)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([90,1026],0,0,-1)
    {
    Vertex="0,0;306,0"
    }
   0.pin([270,1026],0,0,-1)
    {
    }
   0.pin([144,1026],0,0,-1)
    {
    }
   -Sticky-([180,1476],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,1476,540,1530
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Objective Function Formulation:
Keep the fundamental component closer to the reference and minimize 3rd, 5th and 7th harmonics."
    }
   -Sticky-([72,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,72,558,288
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
In this example, SIMPLEX optimizer is used to find the optimum firing angles which minimizes 3rd, 5th and 7th harmonics generated.

PSCAD project designed by: S. Filizadeh

References:
1) A.M.Gole, S. Filizadeh, P.L. Wilson, \"Inclusion of Robustness into Design Using Optimization-Enabled Transient Simulation\"
2) A.M. Gole, S. Filizadeh, R.W. Menzies,  P.L. Wilson, \"Electromagnetic Transients Simulation as an Objective Function Evaluator for Optimization of Power System Performance\",  Proceedings, IPST'03 - International Conference ofn Power Systems Transients, New Orleans, September 28 - October 2, 2003
"
    }
   -Wire-([612,1008],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Plot-([630,72],0)
    {
    Title = "Voltage and Current Waveforms"
    Draw = 1
    Area = [0,0,504,288]
    Posn = [630,72]
    Icon = [-1,-1]
    Extents = 0,0,504,288
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,113],"kV")
     {
     Options = 137
     Units = ""
     Curve(25390448,"Vabc",8388608,,,)
     }
    Graph([0,113],[0,0,504,112],"kA")
     {
     Options = 137
     Units = ""
     Curve(25467416,"Iabc",8388608,,,)
     }
    }
   -ControlPanel-([774,936],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = 630,558
    Posn = 774,936
    Extents = 0,0,360,126
    Meter(25480624)
    Meter(25483304)
    Meter(25486080)
    Meter(25514240)
    Meter(25460800)
    }
   -PolyMeter-(25449040,630,648,1134,774)
    {
    Title = "Voltage Harmonics"
    Flags = 2
    State = 1
    Icon = -1,-1
    Posn = 630,648
    Extents = 0,0,504,126
    }
   -PolyMeter-(25488856,630,792,1134,900)
    {
    Title = "Current Harmonics"
    Flags = 2
    State = 1
    Icon = -1,-1
    Posn = 630,792
    Extents = 0,0,504,108
    }
   -Wire-([882,1188],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([702,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([774,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([846,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([918,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([450,468],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([450,558],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([450,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([450,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([216,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Plot-([630,378],0)
    {
    Title = "Gate Signals"
    Draw = 1
    Area = [0,0,504,252]
    Posn = [630,378]
    Icon = [-1,-1]
    Extents = 0,0,504,252
    XLabel = " "
    AutoPan = "false,75"
    PGraph([0,0],[0,0,504,189],"PolyGraph")
     {
     Options = 2
     Curve(25415408,"G1_a",33554432,,,-1)
     Curve(25418104,"G2_a",16809984,,,-1)
     Curve(25420880,"G1_b",0,,,1)
     Curve(25423824,"G2_b",16809984,,,1)
     Curve(25426600,"G1_c",0,,,1)
     Curve(25429352,"G2_c",16809984,,,1)
     }
    }
   0.const([72,522],0,0,10)
    {
    Name = ""
    Value = "$(freq)"
    }
   -ControlPanel-([126,612],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 126,612
    Extents = 0,0,90,126
    Slider(25517104)
    }
   }
  }
 }

